# Sliced Invoices - WordPress Invoice Plugin

Contributors: SlicedInvoices  
Donate link: http://slicedinvoices.com/  
Tags: invoice, invoicing, invioce, pdf invoice, quote, pdf quote, estimate, pdf estimate, billing, bills, paypal, bill clients, invoice clients, email invoice, invoice online, recurring invoice, recurring billing, invoice generator, invoice system, accounting, ecommerce  
Requires at least: 4.0  
Tested up to: 6.9
Requires PHP: 5.5
Stable tag: 3.10.0
License: GPLv2
License URI: http://www.gnu.org/licenses/gpl-2.0.html  

A WordPress invoicing plugin for creating invoices and quotes. Online payments, manage clients, reports, exports, taxes & more.

## Description
### A flexible, well-supported, and easy-to-use WordPress invoicing plugin to create professional quotes and invoices that clients can pay for online.

Sliced Invoices is an invoicing system that is easy to use but at the same time comes packed with features to help make your quoting and invoicing a breeze.

### Sliced Invoices - General Features

*   Send Quotes and Invoices and get paid online
*   Many customization options
*   Lots of filters, actions and template tags
*   Pre-defined line items
*   Auto increment of Invoice &amp; Quote numbers
*   Set custom Invoice &amp; Quote prefixes and/or suffixes
*   Flexible tax settings (global, per Invoice/Quote or per line item)
*   Customizable email templates including subject and content
*   Custom email from name and email address
*   Bcc yourself into all client emails
*   Send clients emails at the click of a button
*   Send clients automatic payment reminder emails
*   Clone existing Quotes &amp; Invoices
*   3 customizable Invoice & Quote templates
*	Customize templates using CSS
*	Add your logo and business details to Invoices & Quotes
*   Bulk CSV import of Quotes &amp; Invoices
*   Support for WordPress Multisite (network activated)

### Invoices - Key Features

*   Online Invoice payments with PayPal Express Checkout (or paid Stripe extension)
*   Offline payment methods (Bank, check, money order or anything else)
*   Name Invoices whatever you like (such as Bills, Tax Invoice or anything else)
*   Set default due date (x number of days from Invoice date)
*   Set custom Terms & Conditions for Invoices
*   Invoice reporting
*   Export Invoices to CSV
*   Invoice in any currency

### Quotes - Key Features

*   Commenting system for Quotes
*   Clients can accept or decline Quotes
*   Convert Quotes to Invoices with one click
*   Name Quotes whatever you like (such as Estimate or anything else)
*   Set custom Terms & Conditions for Quotes
*   Quote reporting
*   Export Quotes to CSV
*   Quote in any currency


Sliced Invoices is a feature-packed and flexible invoicing system for WordPress, check out how easy it is to add an invoice in this **very quick 45 second video**.

https://www.youtube.com/watch?v=9V6VRidkZFk

### Sliced Invoices - Free & Paid Extensions

*   [PDF quotes & PDF invoices](https://slicedinvoices.com/extensions/pdf-email/?utm_source=WordPress&utm_medium=Readme&utm_content=PDF-Email&utm_campaign=Free) extension
*   [Client Area](https://slicedinvoices.com/extensions/client-area/?utm_source=WordPress&utm_medium=Readme&utm_content=Client-Area&utm_campaign=Free) extension
*   [Contact Form 7](https://wordpress.org/plugins/sliced-invoices-contact-form-7/) extension (free)
*   [Formidable Forms](https://wordpress.org/plugins/sliced-invoices-formidable-forms/) extension (free)
*   [Gravity Forms](https://wordpress.org/plugins/sliced-invoices-gravity-forms/) extension (free)
*   [Authorize.Net Gateway](https://slicedinvoices.com/extensions/authorize-net-payment-gateway/?utm_source=WordPress&utm_medium=Readme&utm_content=authorize_net&utm_campaign=Free)
*   [Braintree Gateway](https://slicedinvoices.com/extensions/braintree-payment-gateway/?utm_source=WordPress&utm_medium=Readme&utm_content=Braintree&utm_campaign=Free)
*   [Stripe Gateway](https://slicedinvoices.com/extensions/stripe-payment-gateway/?utm_source=WordPress&utm_medium=Readme&utm_content=Stripe&utm_campaign=Free)
*   [Additional Tax](https://slicedinvoices.com/extensions/additional-tax/?utm_source=WordPress&utm_medium=Readme&utm_content=Additional-Tax&utm_campaign=Free) extension (free)
*   [Better URL's](https://slicedinvoices.com/extensions/better-urls/?utm_source=WordPress&utm_medium=Readme&utm_content=Better-URLs&utm_campaign=Free) extension (free)
*   [Deposit Invoices](https://slicedinvoices.com/extensions/deposit-invoices/?utm_source=WordPress&utm_medium=Readme&utm_content=Deposit-Invoices&utm_campaign=Free) extension
*   [Partial Payments](https://slicedinvoices.com/extensions/partial-payments/?utm_source=WordPress&utm_medium=Readme&utm_content=partial_payments&utm_campaign=Free) extension
*   [Recurring Invoices](https://slicedinvoices.com/extensions/recurring-invoices/?utm_source=WordPress&utm_medium=Readme&utm_content=Recurring-Invoices&utm_campaign=Free) extension
* 	Plus many more available [here](https://slicedinvoices.com/extensions/?utm_source=WordPress&utm_medium=Readme&utm_content=Extensions&utm_campaign=Free)

Our support is fantastic (check out the [reviews](https://wordpress.org/support/plugin/sliced-invoices/reviews/)) and if you need a feature that you can't see, just ask and we will see if we can add it for a future release.

> <strong>Visit our website to find out more</strong>
>
> [Features](https://slicedinvoices.com/plugin-features/?utm_source=WordPress&utm_medium=Readme&utm_content=Features&utm_campaign=Free) | [Getting Started](https://slicedinvoices.com/support/getting-started/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=Support&utm_campaign=Free) | [Extensions](https://slicedinvoices.com/extensions/?utm_source=WordPress&utm_medium=Readme&utm_content=Extensions&utm_campaign=Free) | [Bundles](https://slicedinvoices.com/bundles/?utm_source=WordPress&utm_medium=Readme&utm_content=Bundles&utm_campaign=Free) | [FAQ](https://wordpress.org/plugins/sliced-invoices/faq/)

## Installation
1. Upload plugin to the `/wp-content/plugins/` directory
1. Activate the plugin through the 'Plugins' menu in WordPress
1. Go to Sliced Invoices --> General and fill in the details under each section before adding any quotes and invoices


## Frequently Asked Questions

### Minimum System Requirements

* WordPress 4.0 or newer
* PHP version from 5.5 up to 8.2

### Where can I find documentation?

There is full documentation as well as a Getting Started guide at [our website](https://slicedinvoices.com/support/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=documentation&utm_campaign=Free)

### Where can I get help?

For all support issues please [open a Support Ticket on our website](https://slicedinvoices.com/support-ticket/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=support&utm_campaign=Free).

### Can I customize invoice and quote templates?

Yes, you can have full control over the look of the invoices and quotes by using CSS or creating your own template, which is much the same as creating a page or post template. Or you can simply use one of the 3 inbuilt templates. Read more about how to customize the templates in [this guide](https://slicedinvoices.com/support/quote-invoice-templates/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=Support&utm_campaign=Free)

### Can clients create quote requests?

Yes, you can use either one of our free extensions for this. We have a [Gravity Forms extension](https://wordpress.org/plugins/sliced-invoices-gravity-forms/) and a [Contact Form 7 extension](https://wordpress.org/plugins/sliced-invoices-contact-form-7/) available which allow you to easily set up a form on your website to create quotes automatically.

### Can clients pay for their invoices online?

Yes, your clients can pay online using PayPal, meaning that they can pay with their PayPal account or with their credit card. There is also a [Stripe Extension](https://slicedinvoices.com/extensions/stripe-payment-gateway/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=Stripe&utm_campaign=Free) available and more payment gateways too.

### Can clients see a list of all their invoices and quotes?

Yes, there is an extension available that gives clients a full dashboard to view their invoices and quotes as well as update their business details - [Client Area Extension](https://slicedinvoices.com/extensions/client-area/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=Client-Area&utm_campaign=Free).

### Can I create PDF invoices and PDF quotes?

Yes, there is a PDF extension available to do just that (as well as other things like sending emails direct to clients). The [PDF & Email Extension](https://slicedinvoices.com/extensions/pdf-email/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=PDF-Email&utm_campaign=Free) will add a 'Print PDF' button to the admin area and also to the top of the invoice, allowing your client to easily print the invoice to PDF.

### Are recurring and part payment invoices supported?

Yes they are, but these are premium extensions that are available in the [extension marketplace](https://slicedinvoices.com/extensions/pdf-email/?utm_source=WordPress&utm_medium=Readme-FAQ&utm_content=Extensions&utm_campaign=Free)

### Can I call Invoices and Quotes something else

Yes, Invoices and quotes are called many different things in different parts of the world which is why we have made it easy to label your invoice or quote as anything you like.

Invoices could be renamed to Tax Invoice, Bill, Sale, Account, Statement or whatever else you desire.
Quotes could be renamed to Estimate, Proposal, Tender, Bid or anything else.

### Does Sliced Invoices work with WordPress multisite?

Yes, it does!  As of version 3.0.0 you can network activate Sliced Invoices in WP Multisite.

### What languages are available?

This plugin currently includes translations for the following languages:

*   French
*   German
*   Hungarian
*   Italian
*   Romanian
*   Russian
*   Spanish
*   Ukrainian

There is a Portable Object Template (.POT) available in the "/languages" directory.  If you would like to contribute a translation of your own for a language we don't have yet, please let us know!


## Screenshots
1. Example invoice using Template 1. There are 3 invoice templates and you can also style using CSS or create your own template
2. Reports page for quotes and invoices
3. List of invoices (shows the quick edit option)
4. Editing a quote
5. Business settings page
6. Invoices settings page
7. Translate settings page
8. Payments settings page
9. General settings page


## Changelog
###  3.10.0
* NEW: replaced "Clone" feature with a more user friendly "Copy to New [Invoice/Quote]" feature. [See our blog post for more info](https://slicedinvoices.com/blog/new-features-sliced-invoices-v3-10-0-update/)
* NEW: automatically regenerate quote/invoice slug when changing quote/invoice title.
* UPDATE: change "Create new Invoice from Quote" feature to follow similar logic as "Copy to New [Invoice/Quote]" feature.
* UPDATE: add method `set_as_draft` to class `Sliced_Quote`.
* UPDATE: add new hooks `sliced_invoices_converted_quote_to_invoice`, `sliced_invoices_created_invoice_from_quote`, and `sliced_invoices_duplicated_quote_invoice`.
* UPDATE: exclude quotes and invoices from default WordPress sitemap.
* UPDATE: update .pot file for translations.
* FIX: duplicate log entries being created upon status changes.
* FIX: issue on invoice editing page where accepted payment methods checkboxes could show as being enabled when they're really not.

###  3.9.5
* FIX: PHP warning (#207167).

###  3.9.4
* FIX: calculations on quote/invoice editing page not updating when a line item is removed.
* FIX: make some missing strings in the "Email to client" popup translatable.
* FIX: change wording in the "Invoice History" log to clarify whether a payment made was successful or failed.
* UPDATE: automatically add due date when invoice converted from quote.
* UPDATE: update .pot file for translations.

###  3.9.3
* FIX: restrict access to sending emails to Adminstrator users only.

###  3.9.2
* UPDATE: add filter `sliced_invoices_check_for_reminder_args`.
* UPDATE: German translation update (thanks to Christian Högl).
* UPDATE: minor CSS/styling updates (thanks to Dax Liniere).
* FIX: PHP 8.1/8.2 notices.

###  3.9.1
* UPDATE: German translation update (thanks to Thorsten Wollenhöfer).
* UPDATE: Spanish translation update (thanks to Lolo Marchal).
* FIX: pre-defined line items not populating description field since 3.9.0.
* FIX: Sliced_Shared::get_raw_number() not always returning float.

###  3.9.0
* NEW: add "Create new Invoice from Quote" button on quote editing page; renamed existing "Convert to Invoice" button "Convert Quote to Invoice" for extra clarity.
* NEW: add fields for both live and sandbox PayPal API keys (now you can store them together and easily switch with the "Gateway Mode" setting).
* NEW: add global functions `sliced_invoices_create_invoice` and `sliced_invoices_create_quote` for creating invoices/quotes programmatically.
* NEW: add option "Decline Reason Required" under Quote Settings.
* NEW: autofill username when adding new client using "Add New Client" modal.
* NEW: automatically mark invoices as "Paid" when entering manual payments, if there is zero balance remaining.
* NEW: improved "Discount" field now has options for fixed amount vs percentage, and before tax vs after tax.
* UPDATE: add compatibility with PHP 8.0. (IMPORTANT - if you are planning to try PHP 8, please be sure to update ALL your Sliced Invoices plugins/extensions to the latest versions BEFORE you update PHP).
* UPDATE: add extra checks to prevent quotes from being accepted or declined more than once.
* UPDATE: add new filters `sliced_get_email_headers`, and `sliced_invoices_non_cloneable_post_metas`.
* UPDATE: add new hooks `sliced_invoices_admin_before_create_invoice_from_quote`, `sliced_invoices_admin_after_create_invoice_from_quote`, `sliced_invoices_admin_before_convert_quote_to_invoice`, and `sliced_invoices_client_before_accept_quote`.
* UPDATE: add parameter `$new_post_id` to hook `sliced_client_accepted_quote`.
* UPDATE: remove deprecated filters `sliced_admin_display_totals_after_tax`, and `sliced_get_line_item_totals`.
* UPDATE: remove filter `sliced_totals_discounts` (not used), replace with new filters `sliced_totals_discounts_before_tax` and `sliced_totals_after_tax`.
* UPDATE: rename hook `sliced_manual_convert_quote_to_invoice` to `sliced_invoices_admin_after_convert_quote_to_invoice`.
* UPDATE: update .pot file for translations.
* UPDATE: update Spanish translation (thanks to Lolo Marchal).
* UPDATE: update version of bundled CMB2 library to latest.
* UPDATE: various CSS/styling tweaks, textual changes, code refactoring.
* FIX: date filter not working with "Export as CSV" button.
* FIX: don't filter out current user from "Clients" dropdown. (Allows you to assign an invoice to yourself, if you want).
* FIX: issue with populating pre-defined line items after deleting previous line items.
* FIX: issue with Quick Edit removing HTML formatting from Terms and Conditions field.
* FIX: various minor translation issues; removed the word "Bummer". :(

###  3.8.17
* FIX: commas incorrectly removed from "To" field in email preview window, whenever multiple email addresses filtered in.
* FIX: second-order SQL injection vulnerability if an existing meta_key contains unsafe code (thanks to Wordfence).  NOTE: to exploit this, an attacker would need to first be logged in as an administator, and be able to insert a specially-crafted post meta containing malicious code.  There is no direct danger; this could only happen if someone already had access to your database, or if your site was already compromised by some other means.

###  3.8.16
* FIX: browser freezing issue when adding new clients (if many clients exist).
* FIX: CSV formula injection issue in "Export CSV" function (thanks to @Jörgson).
* FIX: make sure all required fields are present when adding new user from "Add New Client" modal.
* FIX: webhook-initiated requests triggering a false "Invoice Viewed" notice.
* FIX: clear all admin notices upon plugin deactivation (some like invoice_viewed and quote_viewed were not being cleared).

###  3.8.15
* FIX: conflict with Gravity Forms plugin >= v2.5.
* FIX: PHP warning.

###  3.8.14
* UPDATE: update Chart.js library.

###  3.8.13
* FIX: change discount input field from type=number to type=text, because some browsers don't allow non-standard decimal separators to be entered (like commas).

###  3.8.12
* FIX: issue with incorrect timestamps (causing a brand new invoice to show "published X hours ago", also causing deposit invoices to incorrectly show as "scheduled").

###  3.8.11
* FIX: issue with duplicate "quote accepted" emails being sent.
* FIX: missing invoice number in "quote accepted" email template.
* FIX: PHP notice.
* UPDATE: client dropdown search now includes searching by email address.

###  3.8.10
* FIX: issue with non-standard decimal separators and tax calculation since last update (v3.8.9).

###  3.8.9
* FIX: change tax rate field from type=number to type=text, because some browsers don't allow non-standard decimal separators to be entered (like commas).
* FIX: "Missed Schedule" notice when editing future (not yet sent) Recurring Invoices.
* UPDATE: add $url param to filter `sliced_invoices_request_data`.
* UPDATE: performance enhancement -- make checking for duplicate invoice numbers much faster.
* UPDATE: minor refactoring.

###  3.8.8
* UPDATE: show email address in add new client search (makes it easier to find the right user).
* UPDATE: minor CSS/styling updates.

###  3.8.7
* FIX: add a check to prevent internal requests from triggering a "invoice viewed" or "quote viewed" notice.
* FIX: issue where post_date is overwritten with current time after save_post (impacts recurring invoices, triggering a false "missed schedule" warning).
* UPDATE: German translation update (thanks to Thorsten Wollenhöfer).
* UPDATE: Russian translation update (thanks to Andrew Reva).

###  3.8.6
* FIX: unable to send email to multiple addresses separated by commas (caused by v3.8.3).

###  3.8.5
* FIX: "Failed to open file, aborting" error in csv importer.

###  3.8.4
* UPDATE: updates required by wordpress.org.

###  3.8.3
* SECURITY UPDATE: security updates per wordpress requirements.
* FIX: conflict with elementor plugin.
* UPDATE: minor CSS/styling updates.

###  3.8.2
* FIX: allow saving empty due date / quote valid until date fields.
* FIX: corrected "create new client" link.

###  3.8.1
* FIX: backwards compatibility for selectWoo scripts (avoids conflict with plugins/themes that are still loading old versions of selectWoo, including Avada theme).

###  3.8.0
* NEW: enhanced client dropdown box on quote/invoice editing pages.
* NEW: changes to the way dates & timestamps are handled and stored. **** If you are using custom templates or custom coding with Sliced Invoices, you may need to update your code. [See our blog post for more info](https://slicedinvoices.com/blog/new-features-sliced-invoices-v3-8-0-update/) ****
* NEW: Italian translation (thanks to Alessio Simone).
* FIX: cloning creates duplicate invoice numbers.
* FIX: issue with quick edit date fields not working correctly with non-English month names.
* FIX: issue where quick edit fields would not save if empty.
* FIX: update date fields on quote/invoice edit pages to reflect site's locale (formerly was in Y-m-d format only).
* UPDATE: various CSS/styling tweaks, textual changes, minor code refactoring.
* UPDATE: various i18n enhancements.
* UPDATE: update .pot file for translations.

###  3.7.5
* NEW: Add email footer text field to free plugin settings page (previously required paid PDF & Email extension).
* NEW: Hungarian translation (thanks to Csaba Kardos).
* UPDATE: update .pot file for translations.

###  3.7.4
* FIX: fixed a few PHP warnings/notices.
* FIX: German translation update (thanks @kratos78).
* FIX: issue with custom CSS fields not allowing the '>' operator.
* UPDATE: minor CSS updates.
* UPDATE: show button panel with "Clear" button in datepickers.
* UPDATE: update .pot file for translations.

###  3.7.3
* FIX: add .map for decimal.js (avoids browser console message in Safari).
* FIX: minor CSS display issue.
* FIX: PHP notice.
* UPDATE: minor code refactoring/performance improvements.
* UPDATE: update version of bundled CMB2 library.

###  3.7.2
* FIX: issue with formatting settings (Settings page incorrectly overriding quote/invoice-specific settings).
* FIX: issue with thickbox dimensions being ignored (minor styling issue).
* UPDATE: add filter 'sliced_reporting_colors'.
* UPDATE: add new email wildcards %last_payment% and %balance%.
* UPDATE: compatibility updates to support new Partial Payments Extension (to be released soon).
* UPDATE: some code refactoring.
* UPDATE: update .pot file for translations.

###  3.7.1
* FIX: issue with Woo Invoices quote display.
* FIX: localization issue with subtotal decimal formatting.

###  3.7.0
* NEW: add new Tax Settings tab; reorganize settings pages & menu slightly.
* NEW: option to show prices inclusive of tax/VAT.
* NEW: updated "Email to Client" window; you can now manually send "payment received" and "payment reminder" emails on demand.
* NEW: German translation (thanks to Reinhard Frenzel).
* FIX: allow line items quantity field to be formatted with or without decimal places.
* FIX: allow thousands separator to contain whitespace, or be empty.
* FIX: extend admin search feature to include quote/invoice number, order number.
* FIX: issue where quote status counts not updated after quote converted to invoice.
* FIX: issue with character encoding in CSV exports.
* FIX: issue with "warning: duplicate invoice number" message not displaying.
* UPDATE: consolidate some invoice/quote side options into collapsibles.
* UPDATE: minor changes to client chooser / client filter dropdowns, to make it easier to find clients.
* UPDATE: separate footer options for quotes, invoices, payment page.
* UPDATE: updated logging system to record when payment reminder emails are sent, etc.
* UPDATE: various CSS/styling tweaks, textual changes, minor code refactoring.
* UPDATE: update .pot file for translations.

###  3.6.7
* FIX: issue with PayPal payments showing the wrong decimal separator (for example, currencies that use a comma "," instead of a period ".").

###  3.6.6
* UPDATE: workaround for Sage-based themes that break our templates.
* FIX: issue with "invoice viewed" and "quote viewed" admin notices not being displayed.

###  3.6.5
* FIX: escaping of HTML entities in CSV export.
* FIX: fix CSS fallback added in v3.6.4 to allow for smaller logos.

###  3.6.4
* UPDATE: add CSS fallback in case logo is too large for email template.
* UPDATE: add new actions 'sliced_invoice_viewed', 'sliced_quote_viewed'.
* UPDATE: minor code refactoring.

###  3.6.3
* FIX: change the way links are encoded in emails, to get around mailgun/sendgrid issues with ampersands (e.g. https://wordpress.org/support/topic/value-in-url-is-changing-to-038/).
* FIX: get quote/invoice status by slug instead of by name.
* FIX: increase priority on admin_body_class hook to avoid conflicts with plugins that misuse this filter (for example, avoids a conflict caused by the plugin "WP-CRM").
* FIX: issue with admin BCC's when using SendGrid.
* FIX: issue with %valid_until% and %due_date% showing "January 1, 1970" if blank.
* UPDATE: add new hook 'sliced_admin_col_after_quote_number'.
* UPDATE: mask some sensitive info in the System Info File.

###  3.6.2
* FIX: new translatable strings not reflecting changes.
* FIX: only count completed payments in totals column.
* FIX: PHP notice.

###  3.6.1
* UPDATE: minor text change.
* FIX: issue with showing more decimal places than allowed in settings.
* FIX: don't show "Discount" line if it equals 0.00.

###  3.6.0
* NEW: Payments section. This box allows you to see detailed payment history for each invoice, add memos to payments, or enter manual payments from the admin side.
* NEW: Taxable checkbox. This allows you to specify whether a line item is taxable or not.  For example, if you have line items for both products and services on the same invoice and only want the products to be taxable, you can now check the "taxable" box just for those line items.
* NEW: revamped "Add New Client" dialog box, adding option to select from existing users (without having to navigate away to WP Users page).
* FIX: minor CSS issues, styling updates.
* FIX: redirect issue when quote converted to invoice when another invoice already has an identical URL slug.
* UPDATE: add additional translatable fields.
* UPDATE: changed title of "invoice notes" and "quote notes" sections to "invoice history" and "quote history", respectively.
* UPDATE: force admin "convert quote to invoice" button to convert regardless of "accepted quote action" setting (for example, even if "accepted quote action" is set to "do nothing").
* UPDATE: improved CSV import/export features.
* UPDATE: optimize some queries for enhanced performance.
* UPDATE: update .pot file.
* UPDATE: various other performance updates, internal enhancements, code refactoring.

###  3.5.4
* FIX: issue where "email to client" button stopped working after using Quick Edit feature, until page was reloaded.
* UPDATE: additional checking to make sure the payment page (selected on the Payment Settings tab) exists, else trigger a warning notice.
* UPDATE: minor textual update.
* UPDATE: mobile styling improvements for payment page.
* UPDATE: update .pot file.

###  3.5.3
* FIX: extend admin search feature to include client fields (name, email, etc.).
* FIX: JavaScript error in console.

###  3.5.2
* FIX: issue with payment reminder emails showing currency symbol from global settings even if invoice is in a different currency.
* FIX: JavaScript rounding issue in admin area invoice totals display.

###  3.5.1
* FIX: display issue with WooCommerce invoices.
* FIX: minor display issues.

###  3.5.0
* NEW: Add quote/invoice views tracking feature (allows you to see the exact date and time your client viewed a quote or invoice).
* NEW: Admin notices feature (intuitively alerts you if there are potential issues needing your attention).
* NEW: French translation (thanks to WebMat - webmat.pro).
* NEW: Spanish translation (thanks to Lolo Marchal).
* NEW: Ukrainian and Russian translations (thanks to Andrew Reva).
* FIX: display issue with Quick Edit feature.
* FIX: minor CSS display issue.
* UPDATE: PayPal gateway IPN handling improvements.
* UPDATE: Update .pot file.

###  3.4.1
* NEW: Add "View PDF" (if available) and "Email to client" shortcuts on admin quote and invoice pages (same as the buttons on the quote/invoice listings pages).
* FIX: issue with payment reminders sending twice in multisite situations.
* FIX: issue with emailed PDFs not formatted correctly when sending multiple.
* FIX: minor display issue.

###  3.4.0
* NEW: Add suffix option for quote and invoice numbers.
* NEW: Add "expired" status for quotes, and automatically change to "expired" once "Valid Until" date has passed.
* NEW: Add filter 'sliced_get_email_recipient'.
* FIX: Issue with Sliced Invoices Extensions not showing updating notifications.
* FIX: Various issues with payment reminder emails.
* UPDATE: Various performance enhancements, including moving certain repetitive tasks from other hooks into the cron to reduce # of queries and memory use during normal plugin usage.
* UPDATE: Minor CSS updates.
* UPDATE: Update .pot file.

###  3.3.5
* NEW: add action 'sliced_pre_curl_exec'.
* NEW: add filter 'sliced_print_message'.
* FIX: fix error with payment reminders in PHP 7.1.
* UPDATE: Compatibility update with PDF & Emails Extension v1.4.4.
* UPDATE: Make PayPal payment success message translatable.
* UPDATE: minor code cleanup, textual updates.
* UPDATE: Update .pot file.

###  3.3.4
* FIX: minor bug fix.

###  3.3.3
* NEW: add filter 'sliced_quote_accept_decline_buttons'.
* FIX: issue where accept/decline quote buttons continue to appear on quote after it's been accepted, allowing users to accept more than once.
* FIX: issue with email preview window becoming blank if you close and reopen it.
* FIX: compatibility issue with Layers theme.

###  3.3.2
* FIX: fix "allowed memory exhausted" error in PHP 7.1.
* FIX: "view invoice..." button blank in payment reminder emails.
* FIX: fix PHP notice.
* UPDATE: Make quote/invoice statuses translatable strings.
* UPDATE: Terms and Conditions field no longer repeats on quote/invoice printouts, if printout longer than 1 page.
* UPDATE: Update .pot file.

###  3.3.1
* FIX: fix deprecated function in PHP 7.x.
* UPDATE: minor CSS updates.
* UPDATE: text in Extras section.

###  3.3.0
* NEW: Change the way quote and invoice numbers are auto-incremented, allow duplicates with a warning.
* NEW: Completely revamped PayPal gateway, adding support for IPN handling, subscriptions.
* FIX: issue with unpaid invoices sometimes marked "overdue" prematurely.
* FIX: allow custom columns from other plugins (like Reveal IDs).
* FIX: inadvertently blanking out other plugins custom columns on admin users page.
* FIX: fix default ordering and filtering in Quotes and Invoices admin areas.
* FIX: fix PHP notice.
* UPDATE: Optimize some queries for enhanced performance.
* UPDATE: removing $die argument from sliced_print_message().
* UPDATE: Update .pot file.

###  3.2.1
* FIX: issue where other plugins' custom columns inadvertently removed from Users admin page.
* FIX: sort issue preventing auto-saved drafts from being displayed in admin pages.

###  3.2.0
* NEW: new automatic actions to choose from when client accepts quote.
* NEW: ability to edit clients directly from Edit Quote / Edit Invoice screens.
* UPDATE: Add $type to filter sliced_email_attachment.
* UPDATE: Update .pot file for future translations.

###  3.1.3
* FIX: issue with Woo Invoices showing incorrect total in payment confirmation email.

###  3.1.2
* FIX: issue with Woo Invoices tax and shipping not being charged through PayPal.
* FIX: issue with template hooks not being loaded for emails sent via AJAX (i.e. from admin area).

###  3.1.1
* FIX: issue with tax calculation when using comma as decimal separator.
* UPDATE: Minor CSS update (add class 'sliced_form_field_required').

###  3.1.0
* NEW: better streamlined payment process (removed payment popup and 2nd "Pay Now" button -- payment buttons now go straight to the payment page).
* UPDATE: change PayPal gateway to allow guest checkout without PayPal account.
* UPDATE: increase max length of Tax name field from 10 to 100 characters.
* UPDATE: set 'show_admin_bar_front' default to false for new clients created.
* UPDATE: Minor textual update.
* FIX: fix issue with filter 'sliced_invoice_totals_output' not being applied.

###  3.0.1
* FIX: bug with email sending when admin BCC option is on.
* UPDATE: Compatibility update with PDF & Emails Extension v1.3.0.
* UPDATE: Minor CSS update (add class 'sliced-business-logo').
* UPDATE: Minor textual update, code cleanup.

###  3.0.0
* NEW: WordPress Multisite support (network activate).

###  2.876
* FIX: issue with invoices incorrectly being assigned "overdue" status.
* FIX: issue with logs showing incorrect statuses.
* FIX: issue with sending emails to multiple recipients.
* FIX: issue with "return to invoice" link after payment.
* FIX: minor PHP strict standards fix.

###  2.875
* NEW: ability to change currency setting on per-invoice basis, and process payments for multiple currencies through the same gateway.
* NEW: ability to customize "view online" button in email templates.
* UPDATE: add additional translatable fields (when using Easy Translate Extension).
* FIX: minor CSS issue.

###  2.874
* FIX: Compatibility issue with WP Slimstat plugin.
* FIX: Timezone issue.
* UPDATE: minor code cleanup, textual updates.

###  2.873
* FIX: Quotes & Invoices not displaying in Admin Area when quote/invoice date contains non-English characters.
* FIX: PayPal gateway issue with certain WooCommerce add-ons.

###  2.872
* FIX: minor bug fixes.

###  2.871
* FIX: issue with invalid links in automatic reminder emails.
* FIX: minor sorting issue.

###  2.87
* NEW: Ability to customize accepted quote message.
* NEW: add support for qTranslate X (i18n multilingual).
* UPDATE: Compatibility update with Easy Translate Extension v1.1.5.
* FIX: Quotes/invoices being assigned wrong status in some cases.

###  2.861
* FIX: minor fix for legacy PHP 5.3 support.

###  2.86
* UPDATE: Compatibility update with Easy Translate Extension v1.1.4.
* UPDATE: Compatibility update with PDF & Emails Extension v1.2.5.

###  2.85
* NEW: Ability to customize the declined quote message.
* FIX: fix redirect and permissions issue when clients add comments to a quote.
* FIX: minor fix for legacy PHP 5.3 support.

###  2.84
* UPDATE: Compatibility update with Recurring Invoices Extension v2.1.4.

###  2.83
* FIX: Issue with sorting users by Business Name.
* FIX: Issue with 'Decline Quote' reason not being sent in admin notification.

### 2.82 
* UPDATE: Include plugin updater class for extensions.

### 2.81
* FIX: Set email content type to HTML only for our emails, and not sitewide. Previously causing issues with lost password plain text emails.

### 2.80
* UPDATE: Merged in slice-base-plugin-updater.
* FIX: Fix undefined variable id in payments.
* FIX: Fix issue with Tax and Paypal. Tax was not being retrieved for individual invoices as there was no id sent.
* FIX: Modify created date and ensure that there is never a dud date.

### 2.72
* FIX: Error checking for Woo Invoices function if Woo Invoices not installed.

### 2.71
* FIX: Quote number not incrementing properly - modify query that checks last number.
* FIX: Don't escape output of invoice total.
* UPDATE: Add a return to the invoice/quote total table if tied to a Woocommerce order.
* UPDATE: Modify the check for payment methods.
* NEW: Add DejaVu Sans Oblique fonts - for italics in PDF's.

### 2.70
* UPDATE: Major code updates below - a huge thanks to Justin Sternberg of CMB2 fame!
* UPDATE: Update CMB2 to 2.2.1.
* UPDATE: Reset all CMB2 hacks.
* UPDATE: Lots of bug fixes, whitespace and code cleanups.
* FIX: Error with activation errors not displaying.

### 2.62
* FIX: Error with date format and localization.

### 2.61
* FIX: Change to fixed date format in metaboxes to avoid localization errors.
* FIX: Issue with published date not being set correctly if format is d/m/Y.
* FIX: Issue with dropdowns not selecting correct option if doing quick edit.

### 2.60
* NEW: Add Licenses section to settings pages.
* UPDATE: Modify the cURL compatibility check.
* UPDATE: Add integer checks to all timestamps.
* UPDATE: General updates to date and timezone functions.

### 2.50
* NEW: Compatible with WordPress 4.5.
* NEW: Add filters for admin notifications.
* NEW: Add return to invoice link after PayPal payment.
* UPDATE: All timestamps now in local time.
* UPDATE: Unpaid status link now includes Overdue invoices as well.

### 2.40
* NEW: Add 'Bcc' option for all emails.
* UPDATE: Major update and tidy up of notifications, mainly for recurring invoices extension.
* UPDATE: Update CSS for recurring extension.
* FIX: Issue of clearing fields when tabbing in line items.
* FIX: Issue with payment methods and other meta not being added to invoice once client accepts the quote.
* FIX: Issue with 'quote_sent' and 'invoice_sent' logs.
* FIX: Add filter to stop Autoptimize plugin loading on quotes and invoices.

### 2.36
* UPDATE: Rename metabox functions and methods to avoid plugin conflicts.
* UPDATE: Add some styling & minor JS for Woocomerce and Recurring extensions.

### 2.35
* FIX: Issue with auto incrementing numbers.

### 2.34
* FIX: Error with PayPal payments and escaping the PayPal request URL.

### 2.33
* UPDATE: Minor updates with styles and templates.

### 2.32
* UPDATE: Minor updates with styles and templates.

### 2.31
* FIX: Error with wrong tax amounts on payment page.

### 2.30
* NEW: Allow multiple currency.
* UPDATE: Lots and lots of minor UI tweaks.
* UPDATE: Add new fields in quick edit.
* FIX: Performance tweaks and updates.
* FIX: PHP notices when no client name etc.

### 2.25
* NEW: Add support for Fontawesome icon font on invoices and quotes.
* NEW: Make default font on invoices and quotes DejaVuCondensed.
* UPDATE: Minor code updates to deal with PHP7.
* FIX: Fix typos in admin options.
* FIX: Error with recurring invoices not recurring if prefix is blank.

### 2.24
* FIX: Emails sending from default address.

### 2.23
* NEW: Add commenting system for quotes.
* NEW: Add new filter on inline CSS - for new template extension.
* FIX: Error with button not displaying on emails.
* FIX: Error with whitespace at top of emails.

### 2.22
* FIX: Error with invoice and quote auto increment.
* FIX: Error with new notifications adding slashes to content.

### 2.21
* NEW: Add Romanian translation.
* UPDATE: Add new wrapper divs around address template tags.
* FIX: Error with invoice and quote text in activator being around the wrong way.
* FIX: Add new log methods for invoice sent and quote sent.

### 2.20
* UPDATE: Major update to emails and notifications.

### 2.18
* NEW: Minor enhancements and filters to allow new Client Area extension.
* UPDATE: Default template style overhaul.
* UPDATE: Change naming conventions of several filters.
* UPDATE: Change several template tags to allow filtering.
* UPDATE: Add Typography to Bootstrap css.
* UPDATE: Make templates more responsive.
* FIX: Add conditional to stop scripts loading on pages in admin.
* FIX: Add conditional to stop quick edit scripts loading anywhere else but needed.
* FIX: Minor admin style sheet changes.

### 2.17
* FIX: Bug with tax calculations and showing Fatal error.

### 2.16
* NEW: Add Tax field on individual invoices and quotes.
* NEW: Filter for filename when exporting and saving PDF's.
* NEW: Filter CSS templates.
* NEW: Extra template added.
* NEW: Template previews in settings.
* FIX: Minor fixes for PDF extension.
* FIX: Issue with quick edit saving as a scheduled post. Force published status.

### 2.15
* NEW: Add description into pre-defined items.
* FIX: Add decimal rounding to the 'raw' output template tags (mainly for PayPal).
* FIX: Issue with invoices being shown on front end archive pages.

### 2.14
* NEW: Add notes section to quotes and invoices to show the history.
* UPDATE: Add footer on admin pages.
* UPDATE: Update .pot file.
* FIX: Bug with datepicker.
* FIX: Conflict adding clients when using Simple Lightbox Gallery plugin.

### 2.13
* FIX: Major re-write of how different currencies are handled.

### 2.12
* FIX: Error with amounts and rates being multiplied by 100.
* UPDATE: Add new actions on front end and edit screens.
* UPDATE: Minor code updates.

### 2.11
* FIX: Error with reporting dates.
* FIX: PHP notices when STRICT error reporting is on.

### 2.10
* NEW: Add the ability to accept or decline quotes.
* FIX: Make Cloudflare ignore jquery and thickbox scripts.
* FIX: Tax calculations via javascript on the edit screens.
* FIX: Lots of small bug fixes and minor code cleanups.
* FIX: Allow global tax to have decimals.

### 2.09
* UPDATE: Add dashicons to payment pages.
* UPDATE: PayPal errors to show error code.
* UPDATE: Various minor updataes to accomodate Woocommerce extension.
* FIX: Escape a couple of URL's.
* FIX: Issue with number format on Rate/Price field if over 999.

### 2.08
* FIX: Issue with metaboxes not saving.

### 2.07
* NEW: Add option for automatic quote Valid Until Date.
* NEW: Add option for automatic invoice Due Date.
* NEW: Add option to hide the Adjust field on quotes and invoices.
* NEW: Add custom updated messages when quote or invoice is updated.
* UPDATE: Change Business Name to Business/Client Name.
* UPDATE: Tidy up UI for adding clients and make more consistent when adding and editing a user.
* UPDATE: Add link and warning label if no payment methods active.
* UPDATE: Remove select all button on payment methods.
* UPDATE: Update Bootstrap CSS to include forms (to allow other gateways).
* FIX: PHP notice with getting last number of quote or invoice.

### 2.06
* NEW: Add Tools page with system info.
* NEW: Add CSV importer.
* UPDATE: Add instructions to Add Client popup.
* UPDATE: Add the word Settings to end of each settings page in menu.
* UPDATE: Update the way PayPal image is added to payment popup (to allow other gateway images).
* UPDATE: Minor UI updates throughout.
* FIX: Error with form submission checks in PayPal gateway (to allow other gateways).

### 2.05
* UPDATE: Tidy up template tags.
* UPDATE: Add actions column.
* FIX: Fix typos in admin options pages.
* FIX: Error saving payment data on activiation.

### 2.04
* NEW: Allow user to choose payment page via dropdown menu in settings.
* UPDATE: Change version numbering format.
* FIX: Headers already sent bug when making payment via PayPal.
* FIX: Issue creating multiple payment pages on repeat activation.

### 2.0.3
* FIX: Error with decimals in quantity field.

### 2.0.2
* Update readme.
* Update text in Extras sections.
* Remove outline on logo link.

### 2.0.1
* Update readme information.

### 2.0.0
* Initial release at WordPress.org.
